﻿USE [CC_REFDOC]
GO

/****** Object:  StoredProcedure [App].[NVCC_usp_GetPatientsByPartialNameAndSsn]    Script Date: 6/1/2018 12:30:18 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [App].[NVCC_usp_GetPatientsByPartialNameAndSsn]
	@lastFourOfSsn varchar(4),
	@lastNameStartsWith varchar(50),
	@firstNameStartsWith varchar(50) = null,
	@firstFiveOfSsn varchar(5) = null

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Tamer Rifai 
--Object/SP Name        : NVCC_usp_GetPatientsByPartialNameAndSsn
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 11-17-2017
--
--Last Changed          : 05-31-2018
--Last Changed By		: Tamer Rifai 
--Reason For Change		: Was returning multiple patient records if patients belonged to more than 1 station and we needed just one record per unique ICN
--
--Last Changed          : 05-31-2018
--Last Changed By		: Lavanya Epuri
--Reason For Change		: Fixed the Stored Procedure to get first row for each PatientICN rowset.

--Purpose               : To retrieve all patients matched by a required last 4 of SSN and some portion of last name (and possibly full SSN and First name).
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

	--  SELECT
	--   MIN(PatientSID) as PatientSID
 --     ,MIN(PatientIEN) as PatientIEN
	--  ,PatientICN
 --     ,MIN(Sta3n) as Station
	--  ,MIN(PatientSSN) as PatientSSN
 --     ,MIN(PatientName) as PatientName
	--  ,MIN(BirthDateTime) as [DateOfBirth]
	--  ,MIN(DeathDateTime) as [DateOfDeath]


 --  FROM  CDWWork.SPatient.SPatient
	--WHERE
	--	PatientSSN like '%' + @lastFourOfSsn
	--	AND PatientLastName like @lastNameStartsWith + '%'
	--	AND PatientName <>'*Unknown at this time*'
	--	AND PatientName is not null
	--	AND (@firstFiveOfSsn is null OR PatientSSN like @firstFiveOfSsn + '%')
	--	AND (@firstNameStartsWith is null OR PatientFirstName like @firstNameStartsWith + '%')
	--GROUP BY PatientICN

	  SELECT * 
	  FROM 
	  (
	  SELECT
	   PatientSID
      ,PatientIEN
	  ,PatientICN
      ,Sta3n as Station
	  ,PatientSSN
      ,PatientName
	  ,BirthDateTime as [DateOfBirth]
	  ,DeathDateTime as [DateOfDeath]
	  ,ROW_NUMBER() OVER (PARTITION BY PatientICN  ORDER BY PatientSID DESC) as RN
   FROM  CDWWork.SPatient.SPatient
	WHERE
		PatientSSN like '%' + @lastFourOfSsn
		AND PatientLastName like @lastNameStartsWith + '%'
		AND PatientName <>'*Unknown at this time*'
		AND PatientName is not null
		AND (@firstFiveOfSsn is null OR PatientSSN like @firstFiveOfSsn + '%')
		AND (@firstNameStartsWith is null OR PatientFirstName like @firstNameStartsWith + '%')
	) CTE_Patient
	where RN=1

		
END;



GO


